<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Faker\Factory;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use App\DBRealTestSupport\TableCreation as TC;

class HtlCampMother
{

    public static function build1($idHtlTypeCamp = null, $id = 1)
    {
        $faker = Factory::create();
        $idHtlTypeCamp = $idHtlTypeCamp ?? HtlTypeCampMother::push1()['Id_HtlTypeCamp'];
        return [
            'Id_HtlCamp'            => $id,
            'HtlCamp_Name'          => Str::title($faker->text(rand(5, 250))),
            'HtlCamp_Abrv'          => Str::upper(Util::generateString(10)),
            'HtlCamp_Availability'  => rand(5, 10000),
            'HtlCamp_Order'         => rand(1, 10),
            'HtlCamp_Status'        => $faker->randomElement([1, 2]),
            'Id_HtlTypeCamp'        => $idHtlTypeCamp
        ];
    }

    public static function push1($idHtlTypeCamp = null, $id = 1)
    {
        return self::push(self::build1($idHtlTypeCamp, $id));
    }

    private static function push($object)
    {
        DB::select("CALL `sp_htl_camp_insert` (?,?,?,?,?,?,?,@sts,@cod,@msg,@id)", [
            $object['HtlCamp_Name'],
            $object['HtlCamp_Abrv'],
            '',
            '',
            $object['HtlCamp_Availability'],
            $object['HtlCamp_Status'],
            $object['Id_HtlTypeCamp'],
        ]);
        $response = DB::select('SELECT @sts,@cod,@msg,@id');
        if ($response[0]->{'@sts'} == 200) {
            $object['Id_HtlCamp'] = $response[0]->{'@id'};
        }
        return $object;
    }

    public static function tablesToClear()
    {
        return [TC::htl_camp];
    }
}
