<?php

namespace App\DBRealTestSupport;

use App\Modules\Shared\Application\Util;
use Illuminate\Support\Facades\DB;
use App\DBRealTestSupport\TableCreation as TC;

class ExtraMother
{
    public static function build1($idTypeExtra = null, $id = 1)
    {
        $faker = \Faker\Factory::create();
        $idTypeExtra = $idTypeExtra ?? TypeExtraMother::push1()['Id_TypeExtra'];

        return [
            'Id_Extra' => $id,
            'Extra_Code' => Util::generateString(10),
            'Extra_Name' => $faker->text(rand(5, 250)),
            'Extra_Feature' => $faker->text(rand(5, 250)),
            'Extra_Price' => $faker->randomNumber(4),
            'Extra_PriceConfidential' => $faker->randomNumber(4),
            'Extra_Status' => 1,
            'Extra_Lock' => 1,
            'Id_TypeExtra' => $idTypeExtra
        ];
    }

    public static function push1($idTypeExtra = null, $id = 1)
    {
        return self::push(self::build1($idTypeExtra, $id));
    }

    private static function push($object)
    {
        $response = DB::select("CALL `sp_extra_insert`(?,?,?,?,?,?,?)", [
            $object['Extra_Code'],
            $object['Extra_Name'],
            $object['Extra_Feature'],
            $object['Extra_Price'],
            $object['Extra_PriceConfidential'],
            $object['Extra_Status'],
            $object['Id_TypeExtra'],
        ]);
        $object['Id_Extra'] = $response[0]->Response_Id;
        return $object;
    }

    public static function clear()
    {
        return array_merge(
            BookingMother::clear(),
            [
                TC::TYPE_EXTRA,
                TC::TYPE_EXTRA_TRANSL,
                TC::EXTRA,
                TC::EXTRA_TRANSL,
                TC::BOOKING_EXTRA,
                TC::BOOKING_EXTRA_PASSENGER,
                ...BookingMother::clear()
            ]
        );
    }
}
