<?php

namespace App\DBRealTestSupport;

use Faker\Factory;
use Illuminate\Support\Facades\DB;

class CashMovementMother
{

    public static function buildRedistribute($invoicesIn, $invoicesOut, $idTypePayment, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_CashMovement' => $id,
            'CashMovement_DatePayment'      => date('Y-m-d'),
            'CashMovement_Amount'           => array_reduce($invoicesIn, fn ($p, $c) => $p + $c['Amount'], 0),
            'CashMovement_Currency'         => 'USD',
            'CashMovement_Name'             => $faker->text(rand(5, 100)),
            'CashMovement_LastName'         => $faker->text(rand(5, 100)),
            'CashMovement_Email'            => $faker->email,
            'CashMovement_Country'          => $faker->text(rand(5, 100)),
            'CashMovement_City'             => $faker->text(rand(5, 100)),
            'CashMovement_Address'          => $faker->text(rand(5, 250)),
            'CashMovement_Phone'            => substr($faker->phoneNumber, 0, 20),
            'CashMovement_ReceiptNumber'    => $faker->text(rand(5, 20)),
            'CashMovement_CardLast'         => '-',
            'CashMovement_CardNumber'       => '-',
            'CashMovement_CardBrand'        => '-',
            'CashMovement_CardType'         => '-',
            'CashMovement_CardIssuer'       => '-',
            'CashMovement_Remark'           => '-',
            'Id_TypePayment'                => $idTypePayment,
            'Invoices_In'                   => json_encode($invoicesIn),
            'Invoices_Out'                  => json_encode($invoicesOut)
        ];
    }

    public static function build1($invoices, $idTypePayment, $id = 1)
    {
        $faker = Factory::create();
        return [
            'Id_CashMovement' => $id,
            'CashMovement_DatePayment'      => date('Y-m-d H:i:s'),
            'CashMovement_Amount'           => array_reduce($invoices, fn ($p, $c) => $p + $c['Amount'], 0),
            'CashMovement_Currency'         => 'USD',
            'CashMovement_Name'             => $faker->text(rand(5, 100)),
            'CashMovement_LastName'         => $faker->text(rand(5, 100)),
            'CashMovement_Email'            => $faker->email,
            'CashMovement_Country'          => $faker->text(rand(5, 100)),
            'CashMovement_City'             => $faker->text(rand(5, 100)),
            'CashMovement_Address'          => $faker->text(rand(5, 250)),
            'CashMovement_Phone'            => substr($faker->phoneNumber, 0, 20),
            'CashMovement_ReceiptNumber'    => $faker->text(rand(5, 20)),
            'CashMovement_CardLast'         => '-',
            'CashMovement_CardNumber'       => '-',
            'CashMovement_CardBrand'        => '-',
            'CashMovement_CardType'         => '-',
            'CashMovement_CardIssuer'       => '-',
            'CashMovement_Remark'           => '-',
            'Id_TypePayment'                => $idTypePayment,
            'Require_Gateway'               => 1,
            'Invoices'                      => json_encode($invoices)
        ];
    }

    public static function push1($invoices, $idTypePayment, $tester, $token, $id = 1)
    {
        return self::push(self::build1($invoices, $idTypePayment, $id), $tester, $token);
    }

    public static function invoices($invoices)
    {
        return array_map(fn($inv) => ['Id_Invoice' => $inv->Id_Invoice, 'Amount' => $inv->Invoice_Total], $invoices);
    }

    public static function buildClient($id = 1, $invoices = [['Amount' => '105.00', 'Id_Invoice' => 1]])
    {
        return [
            'Id_CashMovement' => $id,
            'CashMovement_DatePayment'      => date('Y-m-d H:i:s'),
            'CashMovement_Amount'           => '105.00',
            'CashMovement_Currency'         => 'USD',
            'CashMovement_Name'             => 'Jesús',
            'CashMovement_LastName'         => 'Curi',
            'CashMovement_Email'            => 'jesuscuri13@gmail.com',
            'CashMovement_Country'          => 'Per',
            'CashMovement_City'             => 'Cus',
            'CashMovement_Address'          => 'Per-Cus',
            'CashMovement_Phone'            => '987654321',
            'CashMovement_ReceiptNumber'    => '123456789',
            'CashMovement_CardLast'         => '-',
            'CashMovement_CardNumber'       => '-',
            'CashMovement_CardBrand'        => '-',
            'CashMovement_CardType'         => '-',
            'CashMovement_CardIssuer'       => '-',
            'CashMovement_Remark'           => '-',
            'Id_TypePayment'                => 1,
            'Invoices'                      => json_encode($invoices)
        ];
    }

    public static function build2($id = 1, $invoices = [['Amount' => '400.00', 'Id_Invoice' => 1]])
    {
        return [
            'Id_CashMovement' => $id,
            'CashMovement_DatePayment'      => date('Y-m-d H:i:s'),
            'CashMovement_Amount'           => '400.00',
            'CashMovement_Currency'         => 'USD',
            'CashMovement_Name'             => 'Jesús',
            'CashMovement_LastName'         => 'Curi',
            'CashMovement_Email'            => 'jesuscuri13@gmail.com',
            'CashMovement_Country'          => 'Per',
            'CashMovement_City'             => 'Cus',
            'CashMovement_Address'          => 'Per-Cus',
            'CashMovement_Phone'            => '987654321',
            'CashMovement_ReceiptNumber'    => '123456789',
            'CashMovement_CardLast'         => '-',
            'CashMovement_CardNumber'       => '-',
            'CashMovement_CardBrand'        => '-',
            'CashMovement_CardType'         => '-',
            'CashMovement_CardIssuer'       => '-',
            'CashMovement_Remark'           => '-',
            'Id_TypePayment'                => 1,
            'Require_Gateway'               => 1,
            'Invoices'                      => json_encode($invoices)
        ];
    }

    public static function push2($id, $tester, $token)
    {
        return self::push(self::build2($id), $tester, $token);
    }

    private static function push($object, $tester, $token)
    {
        $tester->post(
            '/owner/cashMovement',
            $object,
            [
                'Token' => $token,
                'Url' => $token
            ]
        );
        return $object;
    }

    public static function tablesToClear()
    {
        return array_merge(
            TypePaymentMother::tablesToClear(),
            [
                TableCreation::cash_movement
            ]
        );
    }
}
