<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\WebContactMessage\Domain\WebContactMessageRepository;
use App\Modules\WebContactMessage\Infraestructure\MysqlWebContactMessageRepository;

$app->bind(WebContactMessageRepository::class, fn($app) => $app->make(MysqlWebContactMessageRepository::class));

$router->post(
    '/webContactMessage',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessage\\WebContactMessageInsertController@__invoke'
    ]
);

$router->put(
    '/webContactMessage',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessage\\WebContactMessageUpdateController@__invoke'
    ]
);

$router->delete(
    '/webContactMessage/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessage\\WebContactMessageDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/webContactMessage/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessage\\WebContactMessageIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/webContactMessage/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessage\\WebContactMessageListAllController@__invoke'
    ]
)->where([]);

$router->get(
    '/webContact/{Id_WebContact}/webContactMessage/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'WebContactMessage\\WebContactMessageListController@__invoke'
    ]
)->where(['Id_WebContact' => '[0-9]*']);
