<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlTypeRoom\Domain\HtlTypeRoomRepository;
use App\Modules\HtlTypeRoom\Infrastructure\MysqlHtlTypeRoomRepository;

$app->bind(HtlTypeRoomRepository::class, fn ($app) => $app->make(MysqlHtlTypeRoomRepository::class));

$router->post(
    '/htlTypeRoom',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoom\\HtlTypeRoomInsertController@__invoke'
    ]
);

$router->put(
    '/htlTypeRoom',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoom\\HtlTypeRoomUpdateController@__invoke'
    ]
);

$router->get(
    '/htlTypeRoom/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoom\\HtlTypeRoomIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    'htlCamp/{Id_Camp}/htlTypeRoom/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoom\\HtlTypeRoomListController@__invoke'
    ]
);

$router->delete(
    '/htlTypeRoom/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlTypeRoom\\HtlTypeRoomDeleteController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);
