<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\HtlCampSchedule\Domain\HtlCampScheduleRepository;
use App\Modules\HtlCampSchedule\Infrastructure\MysqlHtlCampScheduleRepository;

$app->bind(HtlCampScheduleRepository::class, fn ($app) => $app->make(MysqlHtlCampScheduleRepository::class));

$router->get(
    '/htlCamp/{Id_HtlCamp}/htlCampSchedule',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'HtlCampSchedule\\HtlCampScheduleListController@__invoke'
    ]
)->where('Id_HtlCamp', '[0-9]*');
