<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\GroupProviderReview\Domain\GroupProviderReviewRepository;
use App\Modules\GroupProviderReview\Infraestructure\MysqlGroupProviderReviewRepository;

$app->bind(GroupProviderReviewRepository::class, fn($app) => $app->make(MysqlGroupProviderReviewRepository::class));

$router->put(
    '/groupProviderReview',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProviderReview\\GroupProviderReviewUpdateController@__invoke'
    ]
);

$router->get(
    '/groupProviderReview/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProviderReview\\GroupProviderReviewIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/groupProviderReview/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProviderReview\\GroupProviderReviewListController@__invoke'
    ]
);

$router->get(
    '/groupProvider/{Id_GroupProvider}/groupProviderReview/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProviderReview\\GroupProviderReviewListFromGroupProviderController@__invoke'
    ]
)->where('Id_GroupProvider', '[0-9]*');

$router->get(
    '/group/{Id_Group}/groupProviderReview/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'GroupProviderReview\\GroupProviderReviewListFromGroupController@__invoke'
    ]
)->where('Id_Group', '[0-9]*');
