<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactTypeReceipt\Domain\FactTypeReceiptRepository;
use App\Modules\FactTypeReceipt\Infraestructure\MysqlFactTypeReceiptRepository;

$app->bind(FactTypeReceiptRepository::class, fn($app) => $app->make(MysqlFactTypeReceiptRepository::class));

$router->put(
    '/factTypeReceipt',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeReceipt\\FactTypeReceiptUpdateController@__invoke'
    ]
);

$router->get(
    '/factTypeReceipt/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeReceipt\\FactTypeReceiptIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factTypeReceipt/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeReceipt\\FactTypeReceiptListController@__invoke'
    ]
);
