<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\FactTypeOperation\Domain\FactTypeOperationRepository;
use App\Modules\FactTypeOperation\Infraestructure\MysqlFactTypeOperationRepository;

$app->bind(FactTypeOperationRepository::class, fn($app) => $app->make(MysqlFactTypeOperationRepository::class));

$router->put(
    '/factTypeOperation',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeOperation\\FactTypeOperationUpdateController@__invoke'
    ]
);

$router->get(
    '/factTypeOperation/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeOperation\\FactTypeOperationIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    '/factTypeOperation/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'FactTypeOperation\\FactTypeOperationListController@__invoke'
    ]
);
