<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\CashMovement\Domain\CashMovementRepository;
use App\Modules\CashMovement\Infraestructure\MysqlCashMovementRepository;

$app->bind(CashMovementRepository::class, fn ($app) => $app->make(MysqlCashMovementRepository::class));

$router->post(
    '/cashMovement/refund',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovement@InsertRefund'
    ]
);

$router->put(
    '/cashMovement',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovement@update'
    ]
);

$router->put(
    '/cashMovement/cycleType',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovement\\CashMovementUpdateCycleTypeController@__invoke'
    ]
);

$router->get(
    '/booking/{idBooking}/cashMovement',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'CashMovement@getAllFromBooking'
    ]
)->where('idBooking', '[0-9]*');
