<?php

/** @var \Laravel\Lumen\Routing\Router $router */

use App\Modules\BookingAssign\Domain\BookingAssignRepository;
use App\Modules\BookingAssign\Infraestructure\MysqlBookingAssignRepository;

$app->bind(BookingAssignRepository::class, fn($app) => $app->make(MysqlBookingAssignRepository::class));

$router->post(
    '/bookingAssign',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingAssign\\BookingAssignInsertController@__invoke'
    ]
);

$router->get(
    '/bookingAssign/{Id}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingAssign\\BookingAssignIndexController@__invoke'
    ]
)->where(['Id' => '[0-9]*']);

$router->get(
    'booking/{Id_Booking}/bookingAssign/{Action}',
    [
        'middleware' => 'Auth_Owner',
        'uses' => 'BookingAssign\\BookingAssignListController@__invoke'
    ]
)->where(['Id_Booking' => '[0-9]*']);
