<?php

namespace App\Providers\ExcelGroupPassengerReportCategorized;

use App\Providers\ExcelReport\Utils;

class ExcelGroupPassengerCells
{
    
    private function tableTitle($data)
    {
        $fnPrint = Utils::print($data[0]);
        $fnWidth = Utils::width($data[1]);
        return Utils::wrap(Utils::top(Utils::border(Utils::bold(Utils::center($fnPrint($fnWidth(Utils::cell())))))));
    }

    private function tableCellLeft($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::left($fnPrint(Utils::cell())))));
    }
    private function tableCellCenter($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::center($fnPrint(Utils::cell())))));
    }
    private function tableCellRight($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::right($fnPrint(Utils::cell())))));
    }

    private function getAllRows($data)
    {
        return array_map(fn($b, $index) => $this->getRow($b, $index), $data, array_keys($data));
    }

    private function getRow($passenger, $i)
    {
        return array_merge(
            [
                $this->tableCellLeft($i + 1),
                $this->tableCellLeft($passenger->Pasajero),
                $this->tableCellLeft($passenger->Dia_ida),
                $this->tableCellLeft($passenger->Mes_ida),
                $this->tableCellLeft($passenger->Anho_ida),
                $this->tableCellLeft($passenger->Dia_retorno),
                $this->tableCellLeft($passenger->Mes_retorno),
                $this->tableCellLeft($passenger->Anho_retorno),
                $this->tableCellLeft($passenger->Sexo),
                $this->tableCellLeft($passenger->Edad),
                $this->tableCellLeft($passenger->Tiene_Review),
                $this->tableCellLeft($passenger->Dia_llenado),
                $this->tableCellLeft($passenger->Mes_llenado),
                $this->tableCellLeft($passenger->Anho_llenado),
                $this->tableCellLeft($passenger->Trip_Advisor),
                $this->tableCellLeft($passenger->Google),
                $this->tableCellLeft($passenger->Social_Network),
                $this->tableCellLeft($passenger->Referencias),
                $this->tableCellLeft($passenger->Otros),
            ]
        );
    }

    public function run($data, $metadata)
    {
        return array_merge(
            [
                array_merge(
                    array_map([$this,'tableTitle'], [
                        ['N°', 6],
                        ['Pasajero', 28],
                        ['D-Ida', 10],
                        ['M-Ida', 10],
                        ['A-Ida', 10],
                        ['D-Retorno', 12],
                        ['M-Retorno', 12],
                        ['A-Retorno', 12],
                        ['Sexo', 8],
                        ['Edad', 8],
                        ['Tiene Review', 15],
                        ['D-Llenado', 12],
                        ['M-Llenado', 12],
                        ['A-Llenado', 12],
                        ['Trip_Advisor', 20],
                        ['Google', 20],
                        ['Social_Network', 20],
                        ['Referencias', 20],
                        ['Otros', 20],
                    ]),
                ),
            ],
            $this->getAllRows($data)
        );
    }
}
