<?php

namespace App\Providers\ExcelBookingReport;

use App\Modules\Booking\Domain\ReportBooking;
use App\Providers\ExcelReport\Utils;

class BookingCells
{
    
    private function tableTitle($data)
    {
        $fnPrint = Utils::print($data[0]);
        $fnWidth = Utils::width($data[1]);
        return Utils::wrap(Utils::top(Utils::border(Utils::bold(Utils::center($fnPrint($fnWidth(Utils::cell())))))));
    }

    private function tableCellLeft($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::left($fnPrint(Utils::cell())))));
    }
    private function tableCellCenter($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::center($fnPrint(Utils::cell())))));
    }
    private function tableCellRight($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::right($fnPrint(Utils::cell())))));
    }

    private function getAllRows($data)
    {
        return array_map(fn($b) => $this->getRow($b), $data);
    }

    private function getRow(ReportBooking $booking)
    {
        $bookingTour = $booking->getReportBookingTour();
        $passenger = $booking->getReportPassenger();
        $user = $booking->getReportUser();
        $invoice = $booking->getReportInvoice();
        return array_merge(
            [[]],
            [
                $this->tableCellCenter($booking->getBookingCode()->getValue()),
                $this->tableCellCenter($booking->getBookingDate()->getValue()->format('d-m-Y')),
                $this->tableCellCenter($booking->getBookingReferredFromName()->getValue()),
                $this->tableCellCenter($booking->getBookingRelationshipName()->getValue()),
                $this->tableCellCenter($booking->getBookingNoPax()->getValue()),
                $this->tableCellRight($booking->getAdminAbrv()->getValue()),
                $this->tableCellLeft($user->getName()->getValue()),
                $this->tableCellLeft($user->getLastName()->getValue()),
                $this->tableCellLeft($user->getEmail()->getValue()),
                $this->tableCellRight($user->getPhone()->getValue()),
                $this->tableCellLeft($bookingTour->getName()->getValue()),
                $this->tableCellLeft($bookingTour->getTourName()->getValue()),
                $this->tableCellCenter($bookingTour->getNoPax()->getValue()),
                $this->tableCellCenter($bookingTour->getTourDuration()->getValue()),
                $this->tableCellRight($bookingTour->getDateStart()->getValue()->format("d-m-Y")),
                $this->tableCellLeft($passenger->getName()->getValue() . ' ' . $passenger->getLastName()->getValue()),
                $this->tableCellCenter($passenger->getStatus()->toString()),
                $this->tableCellLeft($passenger->getDOB()->getValue()->format("d-m-Y")),
                $this->tableCellLeft($passenger->getEmail()->getValue()),
                $this->tableCellRight($passenger->getPhone()->getValue()),
                $this->tableCellRight($passenger->getGender()->getText()),
            ]
        );
    }

    public function run($data, $metadata)
    {
        return array_merge(
            [
                [],
                [],
                array_merge(
                    [[]],
                    array_map([$this,'tableTitle'], [
                        ['BOOKING', 12],
                        ['REGISTRO', 12],
                        ['T. VIAJERO', 12],
                        ['REFERENCIA', 12],
                        ['PAX', 5],
                        ['VENDEDOR', 12],
                        ['CONTACTO NOM.', 20],
                        ['CONTACTO APE.', 20],
                        ['EMAIL', 24],
                        ['TELÉFONO', 12],
                        ['PAQUETE', 22],
                        ['TOUR', 22],
                        ['PAX', 5],
                        ['DÍAS', 6],
                        ['F.SALIDA', 12],
                        ['PASAJERO', 35],
                        ['ESTADO', 12],
                        ['NACIMIENTO', 13],
                        ['EMAIL', 24],
                        ['TELÉFONO', 12],
                        ['SEXO', 12]
                    ]),
                ),
            ],
            $this->getAllRows($data)
        );
    }
}
