<?php

namespace App\Providers\Calendar\ExcelCalendarPaxReport;

use App\Http\Helpers\DateTime;
use App\Modules\Booking\Domain\ReportBooking;
use App\Providers\ExcelReport\Utils;

class ExcelCalendarPaxCells
{

    private function tableTitle($data)
    {
        $fnPrint = Utils::print($data[0]);
        $fnWidth = Utils::width($data[1]);
        return Utils::wrap(Utils::top(Utils::border(Utils::bold(Utils::center($fnPrint($fnWidth(Utils::cell())))))));
    }

    private function tableCellLeft($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::left($fnPrint(Utils::cell())))));
    }

    private function tableMergeLeft($text, $lines)
    {
        $fnPrint = Utils::print($text);
        return Utils::vmerge($lines)(Utils::wrap(Utils::top(Utils::border(Utils::left($fnPrint(Utils::cell()))))));
    }
    private function tableCellCenter($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::center($fnPrint(Utils::cell())))));
    }
    private function tableCellRight($text)
    {
        $fnPrint = Utils::print($text);
        return Utils::wrap(Utils::top(Utils::border(Utils::right($fnPrint(Utils::cell())))));
    }

    private function getAllRows($data)
    {
        return array_map(fn ($b) => $this->getRow($b), $data);
    }

    private function getRow($passenger)
    {

        if ($passenger->rowType == 'empty') {
            $merge = $this->tableCellLeft('');
        } else if ($passenger->rowType == 'child') {
            $merge = $this->tableCellLeft('');
        } else {
            $merge = $this->tableMergeLeft($passenger->room->TypeRoom_Name, $passenger->rowsBelow);
        }

        return array_merge(
            [
                $this->tableCellLeft($passenger->Passenger_Gender == 2 ? 'F' : 'M'),
                $this->tableCellLeft($passenger->Passenger_Name . ' ' . $passenger->Passenger_LastName),
                $this->tableCellLeft($passenger->UserCountry_Code),
                $this->tableCellLeft($passenger->UserCountry_Name),
                $this->tableCellLeft(DateTime::dateTransform($passenger->BookingTour_DateStart)),
                $this->tableCellLeft($passenger->Tour_Name),
                $this->tableCellLeft($passenger->Booking_Code),
                $merge,
                $this->tableCellLeft($passenger->groupName),
            ]
        );
    }

    public function run($data, $metadata)
    {
        return array_merge(
            [
                array_merge(
                    array_map([$this, 'tableTitle'], [
                        ['S', 10],
                        ['PASAJERO', 30],
                        ['COD', 8],
                        ['PAÍS', 25],
                        ['SALIDA', 15],
                        ['TOUR', 40],
                        ['BOOKING', 15],
                        ['HTL-AC', 18],
                        ['GRUPOS', 40],
                    ]),
                ),
            ],
            $this->getAllRows($data)
        );
    }
}
