<?php

namespace App\Modules\WebContactMessageDetail\Domain;

use App\Modules\Shared\Domain\ValueObject\EnumValueObject;

class WebContactMessageDetailStatus extends EnumValueObject
{

    public const DELETED = 0;
    public const INACTIVE = 1;
    public const ACTIVE = 2;
    
    public static function values(): array
    {
        return [ self::DELETED, self::INACTIVE, self::ACTIVE ];
    }

    public static function defaultValue(): int
    {
        return self::ACTIVE;
    }
}
