<?php

namespace App\Modules\WebContactMessageDetail\Application\Create;

use App\Modules\WebContactMessageDetail\Application\Create\CreateWebContactMessageDetailResponse;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailRepository;

final class WebContactMessageDetailCreator
{
    public function __construct(private WebContactMessageDetailRepository $repository)
    {
    }

    public function __invoke(WebContactMessageDetail $webContactMessageDetail): CreateWebContactMessageDetailResponse
    {
        return new CreateWebContactMessageDetailResponse($this->repository->insert($webContactMessageDetail));
    }
}
