<?php

namespace App\Modules\WebContactMessageDetail\Application\Create;

use App\Modules\Package\Domain\IdPackage;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetail;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContactMessage\Domain\IdWebContactMessage;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailDateStart;
use App\Modules\WebContactMessageDetail\Domain\WebContactMessageDetailPackage;

final class CreateWebContactMessageDetailQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageDetailCreator $inserter)
    {
    }

    public function __invoke(CreateWebContactMessageDetailQuery $query): CreateWebContactMessageDetailResponse
    {
        $model = new WebContactMessageDetail(
            new WebContactMessageDetailDateStart($query->dateStart()),
            new WebContactMessageDetailPackage($query->package()),
            new WebContactMessageDetailStatus($query->status()),
            new IdWebContactMessage($query->idWebContactMessage()),
            new IdPackage($query->idPackage()),
        );
        return $this->inserter->__invoke($model);
    }
}
