<?php

namespace App\Modules\WebContactMessageDetail\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateWebContactMessageDetailQuery implements Query
{
    public function __construct(
        private string $dateStart,
        private string $package,
        private int $status,
        private int $idWebContactMessage,
        private int $idPackage
    ) {
    }

    public function dateStart(): string
    {
        return $this->dateStart;
    }

    public function package(): string
    {
        return $this->package;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function idWebContactMessage(): int
    {
        return $this->idWebContactMessage;
    }

    public function idPackage(): int
    {
        return $this->idPackage;
    }
}
