<?php

namespace App\Modules\WebContactMessage\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\IdWebContact;

final class ListWebContactMessageQueryHandler implements QueryHandler
{
    public function __construct(private WebContactMessageLister $inserter)
    {
    }

    public function __invoke(ListWebContactMessageQuery $query): ListWebContactMessageQueryResponse
    {
        return $this->inserter->__invoke(
            new IdWebContact($query->idWebContact()),
            $query->action()
        );
    }
}
