<?php

namespace App\Modules\WebContact\Domain;

use App\Modules\Country\Domain\IdCountry;

/**
 * Status in the group for filtering and display
 */
class WebContact
{

    public function __construct(
        private WebContactName $name,
        private WebContactLastName $lastName,
        private WebContactEmail $email,
        private WebContactCountry $country,
        private WebContactCountryCurrent $countryCurrent,
        private WebContactPhoneCode $phoneCode,
        private WebContactPhone $phone,
        private WebContactStatus $status,
        private IdCountry $idCountry,
        private IdCountry $idCountryCurrent,
        private ?IdWebContact $id = null,
    ) {
    }

    public function id(): IdWebContact
    {
        return $this->id;
    }

    public function name(): WebContactName
    {
        return $this->name;
    }

    public function lastName(): WebContactLastName
    {
        return $this->lastName;
    }

    public function email(): WebContactEmail
    {
        return $this->email;
    }

    public function country(): WebContactCountry
    {
        return $this->country;
    }

    public function countryCurrent(): WebContactCountryCurrent
    {
        return $this->countryCurrent;
    }

    public function phoneCode(): WebContactPhoneCode
    {
        return $this->phoneCode;
    }

    public function phone(): WebContactPhone
    {
        return $this->phone;
    }

    public function status(): WebContactStatus
    {
        return $this->status;
    }

    public function idCountry(): IdCountry
    {
        return $this->idCountry;
    }

    public function idCountryCurrent(): IdCountry
    {
        return $this->idCountryCurrent;
    }
}
