<?php

namespace App\Modules\WebContact\Application\Update;

use App\Modules\WebContact\Application\Update\UpdateWebContactQueryResponse;
use App\Modules\WebContact\Domain\UpdateWebContact;
use App\Modules\WebContact\Domain\WebContact;
use App\Modules\WebContact\Domain\WebContactRepository;

final class WebContactUpdater
{
    public function __construct(private WebContactRepository $repository)
    {
    }

    public function __invoke(UpdateWebContact $webContact): UpdateWebContactQueryResponse
    {
        return new UpdateWebContactQueryResponse($this->repository->update($webContact));
    }
}
