<?php

namespace App\Modules\WebContact\Application\Update;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class UpdateWebContactQuery implements Query
{
    public function __construct(
        private int $id,
        private string $name,
        private string $lastName,
        private string $email,
        private string $phoneCode,
        private string $phone,
        private int $status,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }

    public function lastName(): string
    {
        return $this->lastName;
    }

    public function email(): string
    {
        return $this->email;
    }

    public function phoneCode(): string
    {
        return $this->phoneCode;
    }

    public function phone(): string
    {
        return $this->phone;
    }

    public function status(): int
    {
        return $this->status;
    }

    public function id(): string
    {
        return $this->id;
    }
}
