<?php

namespace App\Modules\WebContact\Application\Index;

use App\Modules\WebContact\Domain\IdWebContact;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class IndexWebContactQueryHandler implements QueryHandler
{
    public function __construct(private WebContactIndexer $inserter)
    {
    }

    public function __invoke(IndexWebContactQuery $query): IndexWebContactQueryResponse
    {
        return $this->inserter->__invoke(new IdWebContact($query->getId()));
    }
}
