<?php

namespace App\Modules\WebContact\Application\Create;

use App\Modules\Country\Domain\IdCountry;
use App\Modules\WebContact\Domain\WebContact;
use App\Modules\WebContact\Domain\WebContactAbrv;
use App\Modules\WebContact\Domain\WebContactName;
use App\Modules\WebContact\Domain\WebContactStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\WebContact\Domain\WebContactCountry;
use App\Modules\WebContact\Domain\WebContactCountryCurrent;
use App\Modules\WebContact\Domain\WebContactEmail;
use App\Modules\WebContact\Domain\WebContactLastName;
use App\Modules\WebContact\Domain\WebContactPhone;
use App\Modules\WebContact\Domain\WebContactPhoneCode;
use App\Modules\WebContact\Domain\WebContactScore;

final class CreateWebContactQueryHandler implements QueryHandler
{
    public function __construct(private WebContactCreator $inserter)
    {
    }

    public function __invoke(CreateWebContactQuery $query): CreateWebContactResponse
    {
        $model = new WebContact(
            new WebContactName($query->name()),
            new WebContactLastName($query->lastName()),
            new WebContactEmail($query->email()),
            new WebContactCountry($query->country()),
            new WebContactCountryCurrent($query->countryCurrent()),
            new WebContactPhoneCode($query->phoneCode()),
            new WebContactPhone($query->phone()),
            new WebContactStatus($query->status()),
            new IdCountry($query->idCountry()),
            new IdCountry($query->idCountryCurrent()),
        );
        return $this->inserter->__invoke($model);
    }
}
