<?php

namespace App\Modules\User\Infraestructure;

use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\User\Domain\UserRepository;
use App\Modules\User\Domain\IdUser;

class MysqlUserRepository implements UserRepository
{

    public function bookingListByTour(
        IdUser $id,
        DateStart $dateStart,
        DateEnd $dateEnd
    ) {
        return RequestChecker::requestSelect(
            'CALL sp_user_booking_list_by_tour(?,?,?,@sts,@cod,@msg)',
            [
                $id->value(),
                $dateStart->value(),
                $dateEnd->value()
            ]
        );
    }
}
