<?php

namespace App\Modules\User\Application\SearchBookingReport;

use App\Modules\Country\Domain\IdCountry;
use App\Modules\WebContact\Domain\WebContact;
use App\Modules\WebContact\Domain\WebContactName;
use App\Modules\WebContact\Domain\WebContactStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;
use App\Modules\User\Domain\IdUser;
use App\Modules\WebContact\Domain\WebContactCountry;
use App\Modules\WebContact\Domain\WebContactCountryCurrent;
use App\Modules\WebContact\Domain\WebContactEmail;
use App\Modules\WebContact\Domain\WebContactLastName;
use App\Modules\WebContact\Domain\WebContactPhone;
use App\Modules\WebContact\Domain\WebContactPhoneCode;

final class SearchBookingByTourUserQueryHandler implements QueryHandler
{
    public function __construct(private UserBookingByTourSearcher $inserter)
    {
    }

    public function __invoke(SearchBookingByTourUserQuery $query): SearchBookingByTourUserResponse
    {
        return new SearchBookingByTourUserResponse($this->inserter->__invoke(
            new IdUser($query->idUser()),
            new DateStart($query->dateStart()),
            new DateEnd($query->dateEnd())
        ));
    }
}
