<?php

namespace App\Modules\TypeTour\Domain;

use App\Modules\Shared\Domain\Aggregate\AggregateAttribute;
use App\Modules\Shared\Domain\Aggregate\AggregateRoot;

class TypeTour extends AggregateRoot
{
    /** @return AgregateAttribute[] */
    protected static function attributes(): array
    {
        return [
            new AggregateAttribute('id', IdTypeTour::class, 'Id_TypeTour'),
            new AggregateAttribute('name', TypeTourName::class, 'TypeTour_Name'),
            new AggregateAttribute('abrv', TypeTourAbrv::class, 'TypeTour_Abrv'),
            new AggregateAttribute('status', TypeTourStatus::class, 'TypeTour_Status'),
        ];
    }

    public function value()
    {
        return [
            'Id_TypeTour' => $this->id->value(),
            'TypeTour_Name' => $this->name->value(),
            'TypeTour_Abrv' => $this->abrv->value(),
            'TypeTour_Status' => $this->status->value(),
        ];
    }

    /** constructor */
    public function __construct(
        private IdTypeTour $id,
        private TypeTourName $name,
        private TypeTourAbrv $abrv,
        private TypeTourStatus $status,
    ) {}

    public function id(): IdTypeTour
    {
        return $this->id;
    }

    public function name(): TypeTourName
    {
        return $this->name;
    }

    public function abrv(): TypeTourAbrv
    {
        return $this->abrv;
    }

    public function status(): TypeTourStatus
    {
        return $this->status;
    }
}
