<?php

namespace App\Modules\TypeBookingAssign\Application\Update;

use App\Modules\TypeBookingAssign\Domain\IdTypeBookingAssign;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssign;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignName;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignStatus;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignAbrv;
use App\Modules\TypeBookingAssign\Domain\TypeBookingAssignScore;

final class UpdateTypeBookingAssignQueryHandler implements QueryHandler
{
    public function __construct(private TypeBookingAssignUpdater $updater)
    {
    }

    public function __invoke(UpdateTypeBookingAssignQuery $query): UpdateTypeBookingAssignQueryResponse
    {
        $model = new TypeBookingAssign(
            new TypeBookingAssignName($query->name()),
            new TypeBookingAssignAbrv($query->abrv()),
            new TypeBookingAssignScore($query->score()),
            new TypeBookingAssignStatus($query->status()),
            new IdTypeBookingAssign($query->id()),
        );
        return $this->updater->__invoke($model);
    }
}
