<?php

namespace App\Modules\TourHtlCamp\Application\List;

use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\TourHtlCamp\Domain\THCIdTour;

final class ListTourHtlCampQueryHandler implements QueryHandler
{
    public function __construct(private TourHtlCampLister $lister) {}

    public function __invoke(ListTourHtlCampQuery $query): ListTourHtlCampResponse
    {
        return new ListTourHtlCampResponse($this->lister->__invoke(
            new THCIdTour($query->idTour()),
            $query->action()
        ));
    }
}
