<?php

namespace App\Modules\Tour\Domain;

use App\Modules\Shared\Domain\Bus\Query\Response;

class Aggregations implements Response
{

    /**
     * @var Aggregation[]
     */
    private array $data;

    public function __construct(Aggregation ...$data)
    {
        $this->data = $data;
    }

    /**
     * @return Aggregation[]
     */
    public function data()
    {
        return $this->data;
    }

    public function addAggregation(Aggregation $aggregation): void
    {
        $this->data[] = $aggregation;
    }
}
