<?php

namespace App\Modules\Tour\Application\List;

use App\Modules\Shared\Domain\QueryList\QueryPaginate;
use App\Modules\Tour\Domain\Aggregations;
use App\Modules\Tour\Domain\CategoryTours;
use App\Modules\Tour\Domain\ListTour;
use App\Modules\Tour\Domain\TourAction;
use App\Modules\Tour\Domain\TypeTours;
use App\Modules\Tour\Domain\TourRepository;

final class TourLister
{
    public function __construct(private TourRepository $repository) {}

    public function __invoke(
        TourAction $list,
        TypeTours $typeTours,
        CategoryTours $categoryTours,
        Aggregations $aggregations,
        QueryPaginate $queryPaginate,
    ) {
        return $this->repository->search(new ListTour(
            $list,
            $typeTours,
            $categoryTours,
            $aggregations,
            $queryPaginate,
        ));
    }
}
