<?php

namespace App\Modules\Tour\Application\List;

use App\Modules\Tour\Application\TourResponse;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;
use App\Modules\Shared\Domain\QueryList\QueryPaginate;
use App\Modules\Tour\Domain\Aggregation;
use App\Modules\Tour\Domain\Aggregations;
use App\Modules\Tour\Domain\CategoryTour;
use App\Modules\Tour\Domain\CategoryTours;
use App\Modules\Tour\Domain\RichTour;
use App\Modules\Tour\Domain\Tour;
use App\Modules\Tour\Domain\TourAction;
use App\Modules\Tour\Domain\TypeTour;
use App\Modules\Tour\Domain\TypeTours;

final class ListTourQueryHandler implements QueryHandler
{
    public function __construct(private TourLister $lister) {}

    public function __invoke(ListTourQuery $query): ListTourResponses
    {
        $response = new ListTourResponses(...array_map(
            fn(Tour $index) => new ListTourResponse(
                $index->id()->value(),
                $index->code()->value(),
                $index->name()->value(),
                $index->urlThumbnail()->value(),
                $index->duration()->value(),
                $index->minPax()->value(),
                $index->availability()->value(),
                $index->availabilityStatus()->value(),
                $index->anticipation()->value(),
                $index->anticipationType()->value(),
                $index->color()->value(),
                $index->score()->value(),
                $index->scoreCant()->value(),
                $index->scoreTotal()->value(),
                $index->status()->value(),
                $index->idCategoryTour()->value(),
                $index->idTypeTour()->value(),
                $index->idCountry()->value(),
                $index->idState()->value(),
                $index->idCity()->value(),
                $index->categoryTour()?->value(),
                $index->typeTour()?->value()
            ),
            $this->lister->__invoke(
                new TourAction($query->list()),
                new TypeTours(...array_map(fn($type) => new TypeTour($type), $query->typeTour())),
                new CategoryTours(...array_map(fn($category) => new CategoryTour($category), $query->categoryTour())),
                new Aggregations(...array_map(fn($aggregate) => new Aggregation($aggregate), $query->aggregation())),
                QueryPaginate::fromData($query->page(), $query->pageSize()),
            )
        ));
        return $response;
    }
}
