<?php

namespace App\Modules\Tour\Application\List;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class ListTourQuery implements Query
{
    public function __construct(
        private string $list,
        /**
         * @var int[] $typeTour
         */
        private array $typeTour,
        /**
         * @var int[] $categoryTour
         */
        private array $categoryTour,
        /**
         * @var string[] $aggregation
         */
        private array $aggregation,
        private ?string $page,
        private ?string $pageSize,
    ) {}

    public function list(): string
    {
        return $this->list;
    }

    /**
     * @return int[]
     */
    public function typeTour(): array
    {
        return $this->typeTour;
    }

    /**
     * @return int[]
     */
    public function categoryTour(): array
    {
        return $this->categoryTour;
    }

    /**
     * @return string[]
     */
    public function aggregation(): array
    {
        return $this->aggregation;
    }

    public function page(): ?string
    {
        return $this->page;
    }

    public function pageSize(): ?string
    {
        return $this->pageSize;
    }
}
