<?php

namespace App\Modules\StatusGroupProvider\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Infraestructure\RequestChecker;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProvider;
use App\Modules\StatusGroupProvider\Domain\StatusGroupProviderRepository;
use App\Modules\StatusGroupProvider\Domain\IdStatusGroupProvider;

class MysqlStatusGroupProviderRepository implements StatusGroupProviderRepository
{

    public function find(string $action)
    {
        return RequestChecker::requestSelect(
            'CALL sp_status_group_provider_list(?,@sts,@cod,@msg)',
            [
                $action
            ]
        );
    }

    public function index(IdStatusGroupProvider $id)
    {
        return RequestChecker::requestSelect(
            'CALL sp_status_group_provider_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(StatusGroupProvider $value)
    {
        return RequestChecker::requestInsert(
            'CALL sp_status_group_provider_insert(?,?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->name()->value(),
                $value->abrev()->value(),
                $value->color()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function update(StatusGroupProvider $value)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_status_group_provider_update(?,?,?,?,?,@sts,@cod,@msg)',
            [
                $value->id()->value(),
                $value->name()->value(),
                $value->abrev()->value(),
                $value->color()->value(),
                $value->status()->value(),
            ]
        );
    }

    public function delete(IdStatusGroupProvider $id)
    {
        return RequestChecker::requestUpdate(
            'CALL sp_status_group_provider_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
