<?php

namespace App\Modules\StatusGroupProvider\Application\Create;

use App\Modules\Shared\Domain\Bus\Query\Query;

final class CreateStatusGroupProviderQuery implements Query
{
    public function __construct(
        private string $name,
        private string $abrev,
        private string $color,
        private int $status,
    ) {
    }

    public function name(): string
    {
        return $this->name;
    }
    public function abrev(): string
    {
        return $this->abrev;
    }
    public function color(): string
    {
        return $this->color;
    }
    public function status(): int
    {
        return $this->status;
    }
}
