<?php

namespace App\Modules\Shared\Infraestructure\Query;

use App\Modules\Shared\Domain\Bus\Query\Query;
use App\Modules\Shared\Domain\Bus\Query\QueryBus;
use App\Modules\Shared\Domain\Bus\Query\Response;
use Illuminate\Bus\Dispatcher;

final class IlluminateQueryBus implements QueryBus
{

    private $queries = [];

    public function __construct(
        protected Dispatcher $bus
    ) {}

    public function ask(Query $query): ?Response
    {
        return $this->bus->dispatch($query);
    }

    public function register(array $map): void
    {
        $this->bus->map($map);
    }
}
