<?php

namespace App\Modules\Shared\Infraestructure;

use App\Modules\Shared\Exceptions\InvalidRequestException;
use Illuminate\Support\Facades\DB;

class Format1Requester
{

    public static function request($query, array $data)
    {
        $responseData = DB::select(
            $query,
            $data
        );

        if (isset($responseData[0]->Response_Success)) {

            if ($responseData[0]->Response_Success != 1) {
                throw new InvalidRequestException([
                    'Response_Status'           => $responseData[0]->Response_Status,
                    'Response_Code'             => $responseData[0]->Response_Code,
                    'Response_Domain'           => 'global',
                    'Response_Message'          => $responseData[0]->Response_Message,
                    'Response_Data'             => null,
                    'Response_Error_Message'    => $responseData[0]->Response_Status != 200 ? $query . ': ' . $responseData[0]->Response_Message : '',
                    'Response_Error_Reason'     => $responseData[0]->Response_Status != 200 ? $query . ': ' . $responseData[0]->Response_Message : '',
                ]);
            } else {
                $data = null;
                if (isset($responseData[0]->Response_Id)) {
                    $data = [ 'Id' => $responseData[0]->Response_Id ];
                }
                return [
                    'Response_Status'           => $responseData[0]->Response_Status,
                    'Response_Code'             => $responseData[0]->Response_Code,
                    'Response_Domain'           => 'global',
                    'Response_Message'          => $responseData[0]->Response_Message,
                    'Response_Data'             => $data,
                    'Response_Error_Message'    => $responseData[0]->Response_Status != 200 ? $query . ': ' . $responseData[0]->Response_Message : '',
                    'Response_Error_Reason'     => $responseData[0]->Response_Status != 200 ? $query . ': ' . $responseData[0]->Response_Message : '',
                ];
            }
        } else {
            return [
                'Response_Status'           => 200,
                'Response_Code'             => 200,
                'Response_Domain'           => 'global',
                'Response_Message'          => '',
                'Response_Data'             => null,
                'Response_Error_Message'    => '',
                'Response_Error_Reason'     => '',
                'Response_Data'             => $responseData,
            ];
        }
    }

    public static function generateResponse($res, $domain)
    {
        $turn = [];
        $turn["Response_Status"]           = $res[0]->Response_Status;
        $turn["Response_Code"]             = $res[0]->Response_Code;
        $turn["Response_Domain"]           = $domain;
        $turn["Response_Message"]          = $res[0]->Response_Message;
        $turn["Response_Data"]             = null;
        $turn["Response_Error_Message"]    = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        $turn["Response_Error_Reason"]     = $res[0]->Response_Status != 200 ? $res[0]->Response_Message : '';
        return $turn;
    }

}
