<?php

namespace App\Modules\Shared\Infraestructure;

use App\Modules\Shared\Domain\Aggregate\AggregateRoot;
use Illuminate\Support\Facades\DB;

class DBRequester
{

    public static function requestSelect($query, array $data)
    {
        $res = DB::select($query, $data);
        return $res;
    }

    public static function requestInsert(AggregateRoot $value): int
    {
        list($query, $values) = $value->insert();
        DB::select($query, $values);
        $response = DB::select('SELECT LAST_INSERT_ID() as `id`');
        return $response[0]->id;
    }

    public static function requestUpdate(AggregateRoot $value): void
    {
        list($query, $values) = $value->update();
        DB::select($query, $values);
    }

    public static function requestUpdatePartial(AggregateRoot $value): void
    {
        list($query, $values) = $value->update();
        DB::select($query, $values);
    }
}
