<?php

namespace App\Modules\Shared\Domain\ValueObject;

use Stringable;
use function in_array;

abstract class Enum implements Stringable
{
    protected static array $cache = [];
    protected $value;

    public function __construct($value)
    {
        $this->value = $value;
        $this->ensureIsBetweenAcceptedValues($value);
    }

    abstract protected function throwExceptionForInvalidValue($value);

    public static function __callStatic(string $name, $args)
    {
        return new static(self::values()[$name]);
    }

    public static function fromString(string $value): Enum
    {
        return new static($value);
    }

    public static function randomValue()
    {
        return self::values()[array_rand(self::values())];
    }

    public static function random()
    {
        return new static(self::randomValue());
    }

    public function value()
    {
        return $this->value;
    }

    public function equals(Enum $other): bool
    {
        return $other == $this;
    }

    public function __toString(): string
    {
        return (string) $this->value();
    }

    private function ensureIsBetweenAcceptedValues($value): void
    {
        if (!in_array($value, static::values(), true)) {
            $this->throwExceptionForInvalidValue($value);
        }
    }
}
