<?php

namespace App\Modules\Shared\Domain;

class ErrorDictionary
{

    public const ERRORS = [
        // 6******
        'INTERNAL' => [
            'LANGUAGE' => [ // 601****
                'INTERNAL_LANGUAGE_EXISTS' => [ // 60101**
                    'INTERNAL_LANGUAGE_EXISTS' => 6010101,
                    'INTERNAL_LANGUAGE_NOT_EXISTS' => 6010100,
                ],
                'INTERNAL_LANGUAGE_EXPIRED' => [ // 60102** 
                    'INTERNAL_LANGUAGE_EXPIRED' => 6010201,
                    'INTERNAL_LANGUAGE_NOT_EXPIRED' => 6010200,
                ]
            ],
            'ADMIN' => [ // 602****
                'INTERNAL_ADMIN_EXISTS' => [ // 60201** 
                    'INTERNAL_ADMIN_EXISTS' => 6020101,
                    'INTERNAL_ADMIN_NOT_EXISTS' => 6020100,
                ],
                'INTERNAL_GROUP_EXPIRED' => [ // 60202**
                    'INTERNAL_GROUP_EXPIRED' => 6020201,
                    'INTERNAL_GROUP_NOT_EXPIRED' => 6020200,
                ]
            ],
            'BOOKING' => [ // 603****
                'INTERNAL_BOOKING_EXISTS' => [ // 60301
                    'INTERNAL_BOOKING_EXISTS' => 6030101,
                    'INTERNAL_BOOKING_NOT_EXISTS' => 6030100,
                ],
            ],
            'PASSENGER' => [ // 605****
                'INTERNAL_PASSENGER_EXISTS' => [ // 60501**
                    'INTERNAL_PASSENGER_EXISTS' => 6050101,
                    'INTERNAL_PASSENGER_NOT_EXISTS' => 6050100,
                ],
                'INTERNAL_PASSENGER_INVOICE_EXISTS' => [ // 60502**
                    'INTERNAL_PASSENGER_INVOICE_EXISTS' => 6050103,
                    'INTERNAL_PASSENGER_INVOICE_NOT_EXISTS' => 6050104,
                ]
            ],
            'PAX_INFORMATION' => [ //610****
                'INTERNAL_PAX_INFORMATION_EXISTS' => [ //61001**
                    'INTERNAL_PAX_INFORMATION_EXISTS' => 6100101,
                    'INTERNAL_PAX_INFORMATION_NOT_EXISTS' => 6100100,
                ],
                'INTERNAL_PAX_INFORMATION_COUNT_PASSENGER' => [ //61002**
                    'INTERNAL_PAX_INFORMATION_PASSENGER_COUNTED' => 6100200,
                ]
            ],
            'GROUP' => [ // 693****
                'INTERNAL_GROUP_EXISTS' => [ //69301**
                    'INTERNAL_GROUP_EXISTS' => 6930101,
                    'INTERNAL_GROUP_NOT_EXISTS' => 6930100,
                ]
            ],
            'GROUP_PASSENGER' => [ // 696****
                'INTERNAL_GROUP_PASSENGER_EXISTS' => [ //69601**
                    'INTERNAL_GROUP_PASSENGER_EXISTS' => 6960101,
                    'INTERNAL_GROUP_PASSENGER_NOT_EXISTS' => 6960100,
                ],
                'INTERNAL_GROUP_PASSENGER_DELETE_FROM_GROUP' => [ //69602**
                    'INTERNAL_GROUP_PASSENGER_DELETE_FROM_GROUP' => 6960201,
                ]
            ],
            'GROUP_PROVIDER' => [ // 697****
                'INTERNAL_GROUP_PROVIDER_EXISTS' => [ //69701**
                    'INTERNAL_GROUP_PROVIDER_EXISTS' => 6970101,
                    'INTERNAL_GROUP_PROVIDER_NOT_EXISTS' => 6970100,
                ],
            ],
            'WEB_CONTACT' => [ // 6153****
                'INTERNAL_WEB_CONTACT_EXISTS' => [ //615301**
                    'INTERNAL_WEB_CONTACT_EXISTS' => 61530101,
                    'INTERNAL_WEB_CONTACT_NOT_EXISTS' => 61530100,
                ]
            ],
            'WEB_CONTACT_MESSAGE_DETAIL' => [ // 6154****
                'INTERNAL_WEB_CONTACT_EXISTS' => [ //615401**
                    'INTERNAL_WEB_CONTACT_EXISTS' => 61540101,
                    'INTERNAL_WEB_CONTACT_NOT_EXISTS' => 61540100,
                ]
            ],
            'HTL_CAMP_BOOKING' => [ // 6170****
                'HTL_CAMP_BOOKING_EXISTS' => [ // 617001**
                    'HTL_CAMP_BOOKING_EXISTS' => 61700101,
                    'HTL_CAMP_BOOKING_NOT_EXISTS' => 61700102
                ],
                'HTL_CAMP_BOOKING_DUPLICATE' => [ // 617002**
                    'HTL_CAMP_BOOKING_DUPLICATE' => 61700201,
                    'HTL_CAMP_BOOKING_NOT_DUPLICATE' => 61700202
                ]
            ],
            'HTL_CAMP_BOOKING_PASSENGER' => [ // 6171****
                'HTL_CAMP_BOOKING_PASSENGER_EXISTS' => [ // 617101**
                    'HTL_CAMP_BOOKING_PASSENGER_EXISTS' => 61710101,
                    'HTL_CAMP_BOOKING_PASSENGER_NOT_EXISTS' => 61710102
                ],
                'HTL_CAMP_BOOKING_PASSENGER_DUPLICATE' => [ // 617102**
                    'HTL_CAMP_BOOKING_PASSENGER_DUPLICATE' => 61710201,
                    'HTL_CAMP_BOOKING_PASSENGER_NOT_DUPLICATE' => 61710202
                ]
            ],
            'HTL_CAMP_LOCK' => [ // 6172****
                'HTL_CAMP_LOCK_EXISTS' => [ // 617201**
                    'HTL_CAMP_LOCK_EXISTS' => 61720101,
                    'HTL_CAMP_LOCK_NOT_EXISTS' => 61720102
                ],
            ]
        ],
        'OWNER' => [ // 7******
            'PAX_INFORMATION' => [ // 710****
                'INTERNAL_PAX_INFORMATION_INSERT' => [ // 71001**
                    'INTERNAL_PAX_INFORMATION_INSERTED' => 7100101,
                ],
                'INTERNAL_PAX_INFORMATION_UPDATE' => [ // 71002**
                    'INTERNAL_PAX_INFORMATION_UPDATED' => 7100201,
                    'INTERNAL_PAX_INFORMATION_UPDATED_WITH_STATUS' => 7100202,
                ],
                'INTERNAL_PAX_INFORMATION_DELETE' => [ // 71003**
                    'INTERNAL_PAX_INFORMATION_DELETED' => 7100301,
                ],
            ],
            'PAX_INFORMATION_PASSENGER' => [ // 711****
                'INTERNAL_PAX_INFORMATION_PASSENGER_INSERT' => [ // 71101**
                    'INTERNAL_PAX_INFORMATION_PASSENGER_INSERTED' => 7110101,
                ],
                'INTERNAL_PAX_INFORMATION_PASSENGER_UPDATE' => [ // 71102**
                    'INTERNAL_PAX_INFORMATION_PASSENGER_UPDATED' => 7110201,
                    'INTERNAL_PAX_INFORMATION_PASSENGER_UPDATED_WITH_STATUS' => 7110202,
                ],
                'INTERNAL_PAX_INFORMATION_PASSENGER_DELETE' => [ // 71103**
                    'INTERNAL_PAX_INFORMATION_PASSENGER_DELETED' => 7110301,
                ],
            ],
            'GROUP' => [ // 793****
                'GROUP_INSERT' => [ // 79301**
                    'GROUP_INSERTED' => 7930101,
                ],
                'GROUP_UPDATE' => [ // 79302**
                    'GROUP_UPDATED' => 7930201,
                ],
                'GROUP_DELETE' => [ // 79303**
                    'GROUP_DELETED' => 7930301,
                ],
                'GROUP_FIND' => [ // 79304**
                    'GROUP_FOUND' => 7930401,
                    'GROUP_NOT_FOUND' => 7930402,
                ],
            ],
            'GROUP_PASSENGER' => [ // 796****
                'GROUP_PASSENGER_FIND' => [ // 79601**
                    'GROUP_PASSENGER_FOUND' => 7960101,
                    'GROUP_PASSENGER_NOT_FOUND' => 7960102
                ],
                'GROUP_PASSENGER_CHANGE' => [ // 79602**
                    'GROUP_PASSENGER_FAIL_ON_CHANGE' => 7960202
                ]
            ],
            'GROUP_PROVIDER' => [ // 797****
                'GROUP_PROVIDER_FIND' => [ // 79701**
                    'GROUP_PROVIDER_FOUND' => 7970101,
                    'GROUP_PROVIDER_NOT_FOUND' => 7970102
                ],
                'GROUP_PROVIDER_CHANGE' => [ // 79702**
                    'GROUP_PROVIDER_FAIL_ON_CHANGE' => 7970202
                ]
            ],
            'WEB_CONTACT' => [ // 7153****
                'WEB_CONTACT_INSERT' => [ // 715301**
                    'WEB_CONTACT_INSERTED' => 71530101,
                ],
                'WEB_CONTACT_UPDATE' => [ // 715302**
                    'WEB_CONTACT_UPDATED' => 71530201,
                ],
                'WEB_CONTACT_DELETE' => [ // 715303**
                    'WEB_CONTACT_DELETED' => 71530301,
                ],
            ],
            'WEB_CONTACT_MESSAGE_DETAIL' => [ // 7155****
                'WEB_CONTACT_MESSAGE_DETAIL_INSERT' => [ // 715501**
                    'WEB_CONTACT_MESSAGE_DETAIL_INSERTED' => 71550101,
                ],
                'WEB_CONTACT_MESSAGE_DETAIL_UPDATE' => [ // 715502**
                    'WEB_CONTACT_MESSAGE_DETAIL_UPDATED' => 71550201,
                ],
                'WEB_CONTACT_MESSAGE_DETAIL_DELETE' => [ // 715503**
                    'WEB_CONTACT_MESSAGE_DETAIL_DELETED' => 71550301,
                ],
            ],
            'FACT_TYPE_DOCUMENT' => [ // 7156****
                'FACT_TYPE_DOCUMENT_FIND' => [ // 715601**
                    'FACT_TYPE_DOCUMENT_FOUND' => 71560101,
                    'FACT_TYPE_DOCUMENT_NOT_FOUND' => 71560102
                ]
            ],
            'HTL_CAMP_BOOKING' => [ // 7170****
                'HTL_CAMP_BOOKING_FIND' => [ // 717001**
                    'HTL_CAMP_BOOKING_FOUND' => 71700101,
                    'HTL_CAMP_BOOKING_NOT_FOUND' => 71700102
                ]
            ],
            'EXTERNAL_API_REQUEST' => [ // 7173****
                'EXTERNAL_API_REQUEST_FIND' => [ // 717301**
                    'EXTERNAL_API_REQUEST_FOUND' => 71730101,
                    'EXTERNAL_API_REQUEST_NOT_FOUND' => 71730102
                ]
            ],
            'GROUP_PASSENGER_MEDIA' => [ // 7177****
                'GROUP_PASSENGER_MEDIA_CREATE' => [ // 717702**
                    'GROUP_PASSENGER_MEDIA_CREATED' => 71770201,
                    'GROUP_PASSENGER_MEDIA_NOT_ACCEPTED' => 71770202
                ]
            ],
            'GROUP_PROVIDER_MEDIA' => [ // 7176****
                'GROUP_PROVIDER_MEDIA_CREATE' => [ // 717602**
                    'GROUP_PROVIDER_MEDIA_CREATED' => 71760201,
                    'GROUP_PROVIDER_MEDIA_NOT_ACCEPTED' => 71760202
                ]
            ]
        ],
        'INTERNAL' => [ // 8******
            'MEDIA' => [ // 801****
                'MEDIA_CREATE' => [ // 80101**
                    'MEDIA_CREATED' => 8010101,
                    'MEDIA_NOT_AVAILABLE' => 8010102
                ]
            ]
        ]
    ];
}
