<?php

namespace App\Modules\Report\Booking\Application\BySellerMonthly;

use App\Modules\Report\Booking\Domain\BySellerMonthlyReportBooking;
use App\Modules\Report\Booking\Domain\ReportBookingRepository;
use App\Modules\Shared\Domain\DateEnd;
use App\Modules\Shared\Domain\DateStart;

final class BySellerMonthlyBookingReporter
{
    public function __construct(private ReportBookingRepository $repository)
    {
    }

    public function __invoke(DateStart $dateStart, DateEnd $dateEnd)
    {
        return $this->repository->search(new BySellerMonthlyReportBooking($dateStart, $dateEnd));
    }
}
