<?php

namespace App\Modules\RedistributionDetail\Application;

use App\Modules\RedistributionDetail\Domain\CreateRedistributionDetail;
use App\Modules\RedistributionDetail\Domain\RedistributionDetailCreateRepository;

class RedistributionDetailCreator {

    private RedistributionDetailCreateRepository $repository;

    public function __construct(
        RedistributionDetailCreateRepository $repository
    ) {
        $this->repository = $repository;
    }

    public function __invoke(CreateRedistributionDetail $model) {
        return $this->repository->create($model);
    }
}