<?php

namespace App\Modules\Question\Domain;

class Question
{

    /** constructor */
    public function __construct(
        private QuestionName $name,
        private QuestionAbrv $abrv,
        private QuestionType $type,
        private QuestionValues $values,
        private QuestionWeight $weight,
        private QuestionGeneral $general,
        private QuestionSeller $seller,
        private QuestionStatus $status,
        private IdTypeProvider $idTypeProvider,
        private ?IdQuestion $id = NULL
    ) {
    }


    public function getName(): QuestionName
    {
        return $this->name;
    }

    public function getAbrv(): QuestionAbrv
    {
        return $this->abrv;
    }

    public function getType(): QuestionType
    {
        return $this->type;
    }

    public function getValues(): QuestionValues
    {
        return $this->values;
    }

    public function getWeight(): QuestionWeight
    {
        return $this->weight;
    }

    public function getGeneral(): QuestionGeneral
    {
        return $this->general;
    }

    public function getSeller(): QuestionSeller
    {
        return $this->seller;
    }

    public function getStatus(): QuestionStatus
    {
        return $this->status;
    }

    public function getIdTypeProvider(): IdTypeProvider
    {
        return $this->idTypeProvider;
    }

    public function getId(): IdQuestion
    {
        return $this->id;
    }
}
