<?php

namespace App\Modules\ProviderTypeProvider\Infraestructure;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRepository;
use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\Shared\Infraestructure\Requester;

class MysqlProviderTypeProviderRepository implements ProviderTypeProviderRepository
{

    public function find(IdLeadBooking $idLeadBooking, string $action)
    {
        return Requester::requestSelect(
            'CALL sp_provider_type_provider_list(?,?,@sts,@cod,@msg)',
            [
                $idLeadBooking->value(),
                $action
            ]
        );
    }

    public function index(IdProviderTypeProvider $id)
    {
        return Requester::requestSelect(
            'CALL sp_provider_type_provider_index(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }

    public function insert(ProviderTypeProvider $value)
    {
        return Requester::requestInsert(
            'CALL sp_provider_type_provider_insert(?,?,?,@sts,@cod,@msg,@id)',
            [
                $value->getStatus()->value(),
                $value->getIdProvider()->value(),
                $value->getIdTypeProvider()->value(),
            ]
        );
    }

    public function update(ProviderTypeProvider $value)
    {
        return Requester::requestUpdate(
            'CALL sp_provider_type_provider_update(?,?,@sts,@cod,@msg)',
            [
                $value->getId()->value(),
                $value->getStatus()->value()
            ]
        );
    }

    public function delete(IdProviderTypeProvider $id)
    {
        return Requester::requestUpdate(
            'CALL sp_provider_type_provider_delete(?,@sts,@cod,@msg)',
            [
                $id->value(),
            ]
        );
    }
}
