<?php

namespace App\Modules\ProviderTypeProvider\Application\List;

use App\Modules\LeadBooking\Domain\IdLeadBooking;
use App\Modules\Shared\Domain\Bus\Query\QueryHandler;

final class ProviderTypeProviderListerQueryHandler implements QueryHandler
{
    public function __construct(private ProviderTypeProviderLister $inserter)
    {
    }

    public function __invoke(ProviderTypeProviderListerQuery $query): ProviderTypeProviderListerResponse
    {
        return $this->inserter->__invoke(
            new IdLeadBooking($query->getIdLeadBooking()),
            $query->getAction()
        );
    }
}
