<?php

namespace App\Modules\ProviderTypeProvider\Application\Index;

use App\Modules\ProviderTypeProvider\Application\Index\ProviderTypeProviderIndexerResponse;
use App\Modules\ProviderTypeProvider\Domain\IdProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProvider;
use App\Modules\ProviderTypeProvider\Domain\ProviderTypeProviderRepository;

final class ProviderTypeProviderIndexer
{
    public function __construct(private ProviderTypeProviderRepository $repository)
    {
    }

    public function __invoke(IdProviderTypeProvider $idProviderTypeProvider): ProviderTypeProviderIndexerResponse
    {
        return new ProviderTypeProviderIndexerResponse($this->repository->index($idProviderTypeProvider));
    }
}
