<?php

namespace App\Modules\ProviderSanction\Domain;

use App\Modules\TypeDocument\Domain\IdTypeDocument;
use App\Modules\UserCountry\Domain\IdUserCountry;

class LightProviderSanction
{

    /** constructor */
    public function __construct(
        private ProviderSanctionName $name,
        private ProviderSanctionLastName $lastName,
        private ProviderSanctionGender $gender,
        private ProviderSanctionEmail $email,
        private ProviderSanctionPhoneCode $phoneCode,
        private ProviderSanctionPhone $phone,
        private ProviderSanctionNoDocument $noDocument,
        private ProviderSanctionAddress $address,
        private ProviderSanctionContactName $contactName,
        private ProviderSanctionContactPhone $contactPhone,
        private ProviderSanctionType $type,
        private ProviderSanctionStatus $status,
        private IdTypeDocument $idTypeDocument,
        private IdUserCountry $idUserCountry,
        private ?IdProviderSanction $id = null
    ) {
    }
    public function name(): ProviderSanctionName
    {
        return $this->name;
    }
    public function lastName(): ProviderSanctionLastName
    {
        return $this->lastName;
    }
    public function gender(): ProviderSanctionGender
    {
        return $this->gender;
    }
    public function email(): ProviderSanctionEmail
    {
        return $this->email;
    }
    public function phoneCode(): ProviderSanctionPhoneCode
    {
        return $this->phoneCode;
    }
    public function phone(): ProviderSanctionPhone
    {
        return $this->phone;
    }
    public function noDocument(): ProviderSanctionNoDocument
    {
        return $this->noDocument;
    }
    public function address(): ProviderSanctionAddress
    {
        return $this->address;
    }
    public function contactName(): ProviderSanctionContactName
    {
        return $this->contactName;
    }
    public function contactPhone(): ProviderSanctionContactPhone
    {
        return $this->contactPhone;
    }
    public function type(): ProviderSanctionType
    {
        return $this->type;
    }
    public function status(): ProviderSanctionStatus
    {
        return $this->status;
    }
    public function idTypeDocument(): IdTypeDocument
    {
        return $this->idTypeDocument;
    }
    public function idUserCountry(): IdUserCountry
    {
        return $this->idUserCountry;
    }
    public function id(): IdProviderSanction
    {
        return $this->id;
    }
}
