<?php

namespace App\Modules\Provider\Infrastructure;

use App\Modules\Provider\Domain\ProviderRepository;
use App\Modules\Provider\Domain\IdProvider;
use App\Modules\Shared\Application\SelectHandler;
use Illuminate\Support\Facades\DB;

class MysqlProviderRepository implements ProviderRepository
{

    public function index(IdProvider $id)
    {
        return (new SelectHandler())->handle(DB::select(
            'CALL sp_provider_index(?)',
            [
                $id->value(),
            ]
        ));
    }
}
