<?php

namespace App\Modules\PaxInformationPassenger\Application\Insert;

use App\Modules\Shared\Domain\Bus\Command\Command;

final class PaxInformationPassengerInsertCommand implements Command
{

    public function __construct(
        private int $remaining,
        private string $status,
        private int $idPaxInformation,
        private int $idPassenger
    ) {
    }

    public function remaining():int
    {
        return $this->remaining;
    }

    public function status():string
    {
        return $this->status;
    }

    public function idPaxInformation():int
    {
        return $this->idPaxInformation;
    }

    public function idPassenger():int
    {
        return $this->idPassenger;
    }
}
