<?php

namespace App\Modules\PaxInformation\Application\Insert;

use App\Modules\PaxInformation\Domain\PaxInformation;

final class PaxInformationInsertConverter
{
    public function __invoke(array $modelList): array
    {
        return array_map(
            fn($model) => new PaxInformation(
                $model->Id_PaxInformation,
                $model->PaxInformation_DateStart,
                $model->PaxInformation_DateEnd,
                $model->PaxInformation_Hour,
                $model->PaxInformation_Name,
                $model->PaxInformation_Origin,
                $model->PaxInformation_Destination,
                $model->PaxInformation_Type,
                $model->PaxInformation_TourDuration,
                $model->PaxInformation_Remark,
                $model->PaxInformation_MasterType,
                $model->PaxInformation_ServiceType,
                $model->PaxInformation_NotificationCount,
                $model->PaxInformation_NotificationStatus,
                $model->PaxInformation_Status,
                $model->Id_Service,
                $model->Service_Code,
                $model->Service_Name,
                $model->Service_Detail,
                $model->PaxInformation_NoPassenger,
                $model->PaxInformation_Provider_JSON
            ),
            $modelList['Response_Data']
        );
    }
}
